package data.scripts.hullmods;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipAPI.HullSize;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.ids.HullMods;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class SWP_MaximizedOrdinance extends BaseHullMod {

    private static final float ENGINE_MALFUNCTION_PROB = 0.025f;
    private static final float WEAPON_MALFUNCTION_PROB = 0.025f;

    private static BlackMagic magic = null;

    public static void addMember(FleetMemberAPI member) {
        if (magic == null || magic.isDone()) {
            magic = new BlackMagic();
            Thread magicThread = new Thread(magic);
            magicThread.start();
        }
        magic.addMember(member);
    }

    public static void addShip(ShipAPI ship) {
        if (magic == null || magic.isDone()) {
            magic = new BlackMagic();
            Thread magicThread = new Thread(magic);
            magicThread.start();
        }
        magic.addShip(ship);
    }

    @Override
    public void applyEffectsBeforeShipCreation(HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getWeaponMalfunctionChance().modifyFlat(id, WEAPON_MALFUNCTION_PROB);
        stats.getEngineMalfunctionChance().modifyFlat(id, ENGINE_MALFUNCTION_PROB);

        ShipAPI ship = (ShipAPI) stats.getEntity();
        if (ship == null) {
            return;
        }
        SectorAPI sector = Global.getSector();
        if (sector != null) {
            CampaignFleetAPI player = Global.getSector().getPlayerFleet();
            if (player != null) {
                for (FleetMemberAPI member : player.getFleetData().getMembersListCopy()) {
                    if (member.getId() != null && ship.getFleetMemberId() != null && member.getId().contentEquals(
                            ship.getFleetMemberId())) {
                        addMember(member);
                        return;
                    }
                }
                addShip(ship);
            } else {
                addShip(ship);
            }
        } else {
            addShip(ship);
        }
    }

    @Override
    public String getDescriptionParam(int index, HullSize hullSize) {
        return null;
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        if (ship.getVariant().hasHullMod(HullMods.CIVGRADE)) {
            return "Can not be installed on civilian ships";
        }
        if (ship.getVariant().hasHullMod("supply_conservation_program")) {
            return "Incompatible with Skeleton Crew";
        }

        return null;
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        return ship != null && !ship.getVariant().getHullMods().contains(HullMods.CIVGRADE) &&
                !ship.getVariant().getHullMods().contains("supply_conservation_program");
    }

    public static final class BlackMagic implements Runnable {

        private boolean done = false;

        private final Set<WeakReference<FleetMemberAPI>> members = new LinkedHashSet<>(5);
        private final Set<WeakReference<ShipAPI>> ships = new LinkedHashSet<>(5);

        @Override
        @SuppressWarnings("SleepWhileInLoop")
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                SectorAPI sector = Global.getSector();
                MutableCharacterStatsAPI stats = null;
                if (sector != null) {
                    PersonAPI player = sector.getPlayerPerson();
                    if (player != null) {
                        stats = player.getStats();
                    }
                }

                synchronized (this) {
                    Iterator<WeakReference<ShipAPI>> iter = ships.iterator();
                    while (iter.hasNext()) {
                        WeakReference<ShipAPI> reference = iter.next();
                        ShipAPI ship = reference.get();
                        if (ship == null) {
                            iter.remove();
                            continue;
                        }

                        if (!ship.getVariant().hasHullMod("maximized_ordinance")) {
                            if (ship.getVariant().computeOPCost(stats) > ship.getHullSpec().getOrdnancePoints(stats)) {
                                ship.getVariant().addMod("maximized_ordinance");
                            } else if (sector != null && !sector.isPaused()) {
                                iter.remove();
                            }
                        }
                    }

                    Iterator<WeakReference<FleetMemberAPI>> iter2 = members.iterator();
                    while (iter2.hasNext()) {
                        WeakReference<FleetMemberAPI> reference = iter2.next();
                        FleetMemberAPI member = reference.get();
                        if (member == null) {
                            iter2.remove();
                            continue;
                        }

                        if (!member.getVariant().hasHullMod("maximized_ordinance")) {
                            if (member.getVariant().computeOPCost(stats) > member.getHullSpec().getOrdnancePoints(stats)) {
                                member.getVariant().addMod("maximized_ordinance");
                            } else if (sector != null && !sector.isPaused()) {
                                iter2.remove();
                            }
                        }
                    }

                    if (ships.isEmpty() && members.isEmpty()) {
                        break;
                    }
                }

                try {
                    Thread.sleep(250); // The whole point of using a separate thread is we don't know when the ship removes the hullmod, so we gotta sleep
                } catch (InterruptedException ex) {
                    break;
                }
            }

            done = true;
        }

        private synchronized void addMember(FleetMemberAPI member) {
            members.add(new WeakReference<>(member));
        }

        private synchronized void addShip(ShipAPI ship) {
            ships.add(new WeakReference<>(ship));
        }

        private boolean isDone() {
            return done;
        }
    }
}
